<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Area extends Model
{
    use HasFactory;

    protected $table = 'areas';

    protected $fillable = [
        'nombre',
        'descripcion',
        'estado',
        'fecha_creacion',
    ];

    protected $casts = [
        'fecha_creacion' => 'datetime',
    ];


    public $timestamps = false; // porque tu tabla no tiene `updated_at`

    // Relación con usuarios (vía tabla intermedia)
    public function usuarios()
    {
        return $this->belongsToMany(Usuario::class, 'usuario_areas')
                    ->withTimestamps()
                    ->withPivot('activo');
    }
}
